/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.network;

import com.redpxnda.respawnobelisks.network.handler.S2CHandlers;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class PlaySoundPacket {
    private final SoundEvent sound;
    private final float pitch;
    private final float volume;

    public PlaySoundPacket(SoundEvent sound, float pitch, float volume) {
        this.sound = sound;
        this.pitch = pitch;
        this.volume = volume;
    }

    public PlaySoundPacket(FriendlyByteBuf buffer) {
        this.sound = Registry.f_122821_.m_6612_(ResourceLocation.m_135820_((String)buffer.m_130277_())).orElse(SoundEvents.f_11675_);
        this.pitch = buffer.readFloat();
        this.volume = buffer.readFloat();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        ResourceLocation loc = Registry.f_122821_.m_7981_((Object)this.sound);
        buffer.m_130070_(loc != null ? loc.toString() : "");
        buffer.writeFloat(this.pitch);
        buffer.writeFloat(this.volume);
    }

    public void handle(Supplier<NetworkManager.PacketContext> supplier) {
        supplier.get().queue(() -> S2CHandlers.playClientSound(this.sound, this.pitch, this.volume));
    }
}

